/* --------------------------------------------------------------------------
RED is on top moving down
BLACK is on bottom moving up
-------------------------------------------------------------------------- */
const int black_lut[][4] =
{
    /* move 1, become king flag, move 2, become king flag */
    { 0,0,0,0 },
    {  1+4, 0    ,  1+5, 0     },
    {  2+4, 0    ,  2+5, 0     },
    {  3+4, 0    ,  3+5, 0     },
    {  4+4, 0    ,  0  , 0     },
    {  5+4, 0    ,  0  , 0     },
    {  6+3, 0    ,  6+4, 0     },
    {  7+3, 0    ,  7+4, 0     },
    {  8+3, 0    ,  8+4, 0     },
    {  9+4, 0    ,  9+5, 0     },
    { 10+4, 0    , 10+5, 0     },
    { 11+4, 0    , 11+5, 0     },
    { 12+4, 0    ,  0  , 0     },
    { 13+4, 0    ,  0  , 0     },
    { 14+3, 0    , 14+4, 0     },
    { 15+3, 0    , 15+4, 0     },
    { 16+3, 0    , 16+4, 0     },
    { 17+4, 0    , 17+5, 0     },
    { 18+4, 0    , 18+5, 0     },
    { 19+4, 0    , 19+5, 0     },
    { 20+4, 0    ,  0  , 0     },
    { 21+4, 0    ,  0  , 0     },
    { 22+3, 0    , 22+4, 0     },
    { 23+3, 0    , 23+4, 0     },
    { 24+3, 0    , 24+4, 0     },
    { 25+4, KING , 25+5, KING  },
    { 26+4, KING , 26+5, KING  },
    { 27+4, KING , 27+5, KING  },
    { 28+4, KING ,  0  , 0     },
    { 0,0,0,0 },
    { 0,0,0,0 },
    { 0,0,0,0 },
    { 0,0,0,0 },
    { 0,0,0,0 },
    { 0,0,0,0 },
    { 0,0,0,0 }
};

const int red_lut[][4] =
{
    /* move 1, become king flag, move 2, become king flag */
    { 0,0,0,0 },
    { 0,0,0,0 },
    { 0,0,0,0 },
    { 0,0,0,0 },
    { 0,0,0,0 },
    {  5-4, KING ,  0  , 0     },
    {  6-5, KING ,  6-4, KING  },
    {  7-5, KING ,  7-4, KING  },
    {  8-5, KING ,  8-4, KING  },
    {  9-4, 0    ,  9-3, 0     },
    { 10-4, 0    , 10-3, 0     },
    { 11-4, 0    , 11-3, 0     },
    { 12-4, 0    ,  0  , 0     },
    { 13-4, 0    ,  0  , 0     },
    { 14-5, 0    , 14-4, 0     },
    { 15-5, 0    , 15-4, 0     },
    { 16-5, 0    , 16-4, 0     },
    { 17-4, 0    , 17-3, 0     },
    { 18-4, 0    , 18-3, 0     },
    { 19-4, 0    , 19-3, 0     },
    { 20-4, 0    ,  0  , 0     },
    { 21-4, 0    ,  0  , 0     },
    { 22-5, 0    , 22-4, 0     },
    { 23-5, 0    , 23-4, 0     },
    { 24-5, 0    , 24-4, 0     },
    { 25-4, 0    , 25-3, 0     },
    { 26-4, 0    , 26-3, 0     },
    { 27-4, 0    , 27-3, 0     },
    { 28-4, 0    ,  0  , 0     },
    { 29-4, 0    ,  0  , 0     },
    { 30-5, 0    , 30-4, 0     },
    { 31-5, 0    , 31-4, 0     },
    { 32-5, 0    , 32-4, 0     },
    { 0,0,0,0 },
    { 0,0,0,0 },
    { 0,0,0,0 }
};

const int black_jump_lut[][5] =
{
    /* over, onto -or- over, onto , become king flag */
    { 0,0,0,0,0 },
    {  1+5,  1+9,  0  ,  0  ,0},
    {  2+4,  2+7,  2+5,  2+9,0},
    {  3+4,  3+7,  3+5,  3+9,0},
    {  4+4,  4+7,  0  ,  0  ,0},
    {  5+4,  5+9,  0  ,  0  ,0},
    {  6+3,  6+7,  6+4,  6+9,0},
    {  7+3,  7+7,  7+4,  7+9,0},
    {  8+3,  8+7,  0  ,  0  ,0},
    {  9+5,  9+9,  0  ,  0  ,0},
    { 10+4, 10+7, 10+5, 10+9,0},
    { 11+4, 11+7, 11+5, 11+9,0},
    { 12+4, 12+7,  0  ,  0  ,0},
    { 13+4, 13+9,  0  ,  0  ,0},
    { 14+3, 14+7, 14+4, 14+9,0},
    { 15+3, 15+7, 15+4, 15+9,0},
    { 16+3, 16+7,  0  ,  0  ,0},
    { 17+5, 17+9,  0  ,  0  ,0},
    { 18+4, 18+7, 18+5, 18+9,0},
    { 19+4, 19+7, 19+5, 19+9,0},
    { 20+4, 20+7,  0  ,  0  ,0},
    { 21+4, 21+9,  0  ,  0  ,KING},
    { 22+3, 22+7, 22+4, 22+9,KING},
    { 23+3, 23+7, 23+4, 23+9,KING},
    { 24+3, 24+7,  0  ,  0  ,KING},
    { 0,0,0,0,0 },
    { 0,0,0,0,0 },
    { 0,0,0,0,0 },
    { 0,0,0,0,0 },
    { 0,0,0,0,0 },
    { 0,0,0,0,0 },
    { 0,0,0,0,0 },
    { 0,0,0,0,0 },
    { 0,0,0,0,0 },
    { 0,0,0,0,0 },
    { 0,0,0,0,0 }
};

const int red_jump_lut[][5] =
{
    /* over, onto -or- over, onto , become king flag */
    { 0,0,0,0,0 },
    { 0,0,0,0,0 },
    { 0,0,0,0,0 },
    { 0,0,0,0,0 },
    { 0,0,0,0,0 },
    { 0,0,0,0,0 },
    { 0,0,0,0,0 },
    { 0,0,0,0,0 },
    { 0,0,0,0,0 },
    {  9-3,  9-7,     0  ,  0  ,KING},
    { 10-4, 10-9,    10-3, 10-7,KING},
    { 11-4, 11-9,    11-3, 11-7,KING},
    { 12-4, 12-9,     0  ,  0  ,KING},
    { 13-4, 13-7,     0  ,  0  ,0},
    { 14-5, 14-9,    14-4, 14-7,0},
    { 15-5, 15-9,    15-4, 15-7,0},
    { 16-5, 16-9,     0  ,  0  ,0},
    { 17-3, 17-7,     0  ,  0  ,0},
    { 18-4, 18-9,    18-3, 18-7,0},
    { 19-4, 19-9,    19-3, 19-7,0},
    { 20-4, 20-9,     0  ,  0  ,0},
    { 21-4, 21-7,     0  ,  0  ,0},
    { 22-5, 22-9,    22-4, 22-7,0},
    { 23-5, 23-9,    23-4, 23-7,0},
    { 24-5, 24-9,     0  ,  0  ,0},
    { 25-3, 25-7,     0  ,  0  ,0},
    { 26-4, 26-9,    26-3, 26-7,0},
    { 27-4, 27-9,    27-3, 27-7,0},
    { 28-4, 28-9,     0  ,  0  ,0},
    { 29-4, 29-7,     0  ,  0  ,0},
    { 30-5, 30-9,    30-4, 30-7,0},
    { 31-5, 31-9,    31-4, 31-7,0},
    { 32-5, 32-9,     0  ,  0  ,0},
    { 0,0,0,0,0 },
    { 0,0,0,0,0 },
    { 0,0,0,0,0 }
};

/* --------------------------------------------------------------------------
The following is the order in which the pieces will be tryed
normally, it makes no difference, but if the game tree gets pruned,
the moves at the bottom could be ignored.
-------------------------------------------------------------------------- */
struct _piece_order_struct {SQUARE m; long q;} piece_order[SQRS_MAX] =
{
    /* piece number, best quality achievable by piece */
    {0,  -1}, /* zero move.  it is important to understand that this move
                 need not be tested except when the piece order has been
                 sorted because after the sort, the 0th element could contain
                 a legal move.  Whereas before the sort, it could not */
    {1,  -1},
    {2,  -1},
    {3,  -1},
    {4,  -1},
    {5,  -1},
    {6,  -1},
    {7,  -1},
    {8,  -1},
    {9,  -1},
    {10, -1},
    {11, -1},
    {12, -1},
    {13, -1},
    {14, -1},
    {15, -1},
    {16, -1},
    {17, -1},
    {18, -1},
    {19, -1},
    {20, -1},
    {21, -1},
    {22, -1},
    {23, -1},
    {24, -1},
    {25, -1},
    {26, -1},
    {27, -1},
    {28, -1},
    {29, -1},
    {30, -1},
    {31, -1},
    {32, -1},
    {33, -1},
    {34, -1}
};
